#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//SpirelloMod01.fsh  by  rubelson 
//https://www.shadertoy.com/view/Ms2BWc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
float f,z,z0;
const float n = 40.;

vec2 xy0 = iResolution.xy/2.;
float time = iTime*0.25;
float h = iResolution.x/32.;
float r0 = iResolution.x/5.5;	// Step of waves
float r1 = iResolution.x/10.5;	// Height of waves
float phi = 35.;

if (iMouse.z > 0.) phi+=(1.-2.*iMouse.y/iResolution.y)*45.;

float pi = 3.14159265;
float p180 = pi / 180.;

float sf = sin(phi * p180);
float cf = cos(phi * p180);

mat2 trot = mat2(cos(time),sin(time),-sin(time),cos(time));

vec2 xy = vec2(0.);
vec2 r = vec2(0.);
vec3 col = vec3(0.);

xy.x = fragCoord.x - xy0.x;  	

z0 = -10000.;

for(float j=0.; j<=n; j++)
  {
  xy.y = abs(xy.x) - n * h + 2. * h * j;
  for(int i=0; i<=1; i++)
	{
	r = xy * trot;
	r.y += sign(r.x) * r0;
	f = cos(pi * length(r) / r0);

	z = xy.y * sf + f * r1 * cf;
	if(z > z0)
		{
		if( abs(xy0.y+z-fragCoord.y) < 2.-.5*abs(f) )
		col = smoothstep(.33, .66, abs(mod(vec3(f+.33,f-.33,f+1.),2.)-1.));
		z0 = z + 1.;
		}
	xy.y += mod(n * h - abs(xy.x), h) * 2.;	
	}
  if(j > n - abs(xy.x) / h) break;
  }
fragColor = vec4(col,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

